clear
close all
clc
singular_plots = 0;
%% Data Importing
sheet_names = {'Pelton','Single','Flat'};
% 32 mm distributor
data = [];
for i = 1:length(sheet_names)
    sheet = sheet_names{i};
    warning off
    T_table = readtable("Turbine Ball Bearings 32 mm Distributor.xlsx","Sheet",sheet);
    warning on
    T_aux = table2array(T_table);T_aux(:,[3 8 13]) = [];
    data.d32.(sheet) = T_aux;
end

for i = 1:length(sheet_names)
    sheet = sheet_names{i};
    warning off
    T_table = readtable("Turbine Ball Bearings.xlsx","Sheet",sheet);
    warning on
    T_aux = table2array(T_table);T_aux(:,[3 8 13]) = [];
    data.d33.(sheet) = T_aux;
end
n_measurements = size(T_aux,2)/4;

%% Coefs and Ambient values
Ts=293;              %Temperatura ambiente durante la prova [K]
k=1.4;               % Rapporto calori specifici
Rg=287.053;          %Costante dell'aria [J/kg/K]
mu=1.81e-5;          %Viscosita` dinamica dell'aria a 20°C [Pa s]
Pa=101325;           %Pressione ambiente durante la prova
ds=2.5*1e-3;        % Diametro foro
% ds = 4.031*(0.24/4.94)*1e-2; % Diametro foro reale
rho=Pa/(Rg*Ts);      %Desità dell'aria alla temperatura della prova
cG=60000/rho;

%% Plots and data post porcessing
% mean_mat = zeros(size(T_aux,1)-2,n_measurements*2);
% % mat_aux_hall = zeros(size(T_aux,1),n_measurements);
% % mat_aux_opt = mat_aux_hall;
case_vec = {'d32','d33'};
if singular_plots
num_case = [32 33];
for j=1:2
    current_case = case_vec{j};
    current_data = data.(current_case);
for i=1:length(sheet_names)
    sheet = sheet_names{i};
    figure
    hold on
    for k = 1:n_measurements
    plot(current_data.(sheet)(:,2+4*(k-1)),current_data.(sheet)(:,3+4*(k-1)),'b-*')
    plot(current_data.(sheet)(:,2+4*(k-1)),current_data.(sheet)(:,4+4*(k-1)),'r-*')
    end
    hold off
    xlabel('Volumetric Flow rate [l/min]')
    ylabel('Angular Speed [rpm]')
    title([sheet ' Turbine, ' num2str(num_case(j)) ' mm Distributor'])
    figureEditor
    
end
end
end

mean_str = cell(1,6);
mean_strct = [];
mean_strctP = [];
mean_fields = cell(1,6);
figure
hold on
for j=1:2
    current_case = case_vec{j};
    current_data = data.(current_case);
for i=1:length(sheet_names)
    sheet = sheet_names{i};
    mean_vec_hall = mean(current_data.(sheet)(:,[3 7 11]),2);
    mean_vec_P = mean(current_data.(sheet)(:,[2 6 10]),2);
    mean_strct.([current_case sheet]) = mean_vec_hall;
    mean_strctP.([current_case sheet]) = mean_vec_P;
    % mean_vec_opt = mean(current_data.(sheet)(:,[4 8 12]),2);
    plot(current_data.(sheet)(:,1),mean_vec_hall,'-*')
    mean_str{i+3*(j-1)} = [current_case ' ' sheet];
    mean_fields{i+3*(j-1)} = [current_case sheet];
end
end
xlabel('Volumetric Flow rate [l/min]')
ylabel('Angular Speed [rpm]')
title('Mean Angular speed for each case')
axis padded
legend(mean_str)
figureEditor

% G theoretical
cd=0.9;
mean_Diam = (30-3.6)*1e-3; % [m]
r_m = mean_Diam/2;
P_s = mean_strctP.d32Single*1e5+1e5;
P_s_delta = mean(P_s(2:end)-P_s(1:end-1),'all');
% P_s(1)/P_s_delta
aux = (10:16)*P_s_delta;
P_s_theo = [aux';P_s]; 
G_theo = zeros(size(P_s_theo));
for i = 1:length(P_s_theo)
G_theo(i) = Portata_Area_eqv(cd,Rg,Ts,P_s_theo(i),Pa,ds);
end

% omega_theo_func = @(Ps) G_theo./(r_m*pi*(d_s/2)^2*P_s*rho^k/Pa);
Af=pi*(ds/2)^2;
u = G_theo/(Af*rho);
% omega_theo = u/r_m*30/pi;
omega_theo = G_theo./(r_m*Af*(P_s_theo*rho^k/Pa).^(1/k))/2;
% omega_theo_func
% V1_theo = sqrt(2*k/(k-1)*Rg*Ts*(1-(Pa./P_s).^((k-1)/k)));
% V1_theo = sqrt(2*(P_s-Pa)/rho);
% u_theo = V1_theo/2;
% omega_theo = u_theo/r_m*30/pi;

legend_str = {'32 mm Distributor','33 mm Distributor'};
for i = 1:length(sheet_names)
sheet = sheet_names{i};
figure
% subplot(1,3,i)
hold on
for j = 1:length(case_vec)
current_case = case_vec{j};
current_data = data.(current_case);
plot(current_data.(sheet)(:,1),mean_strct.([current_case sheet]),'-o')
end
if i==1 || i==2
% plot(current_data.(sheet)(:,1),omega_theo(1:length(current_data.(sheet)(:,1))))
plot(G_theo*cG,omega_theo*30/pi)
legend('32 mm Distributor','33 mm Distributor','Theoretical',"Location","northwest")
else
legend(legend_str,"Location","northwest")
end
hold off
xlabel('Volumetric Flow rate [l/min]')
ylabel('Angular Speed [rpm]')
title([sheet ' Turbine mean angular speed'])
axis padded
figureEditor
end

%% Velocity Triangles
P_s = mean_strctP.d32Pelton*1e5+1e5;
P_s_delta = mean(P_s(2:end)-P_s(1:end-1),'all');
% P_s(1)/P_s_delta
aux = (10:16)*P_s_delta;
P_s_theo = [aux';P_s]; 
G_theo = zeros(size(P_s_theo));
for i = 1:length(P_s_theo)
G_theo(i) = Portata_Area_eqv(cd,Rg,Ts,P_s_theo(i),Pa,ds);
end

figure
hold on
plot(P_s_theo*1e-5,G_theo,'b')
plot(P_s*1e-5,data.d32.Pelton(:,1)/cG,'r-o')
plot(P_s*1e-5,data.d33.Pelton(:,1)/cG,'k-o')
hold off
legend('Theoretical','Experimental $\phi\, 32$','Experimental $\phi\, 33$','Location','northwest')
title('Theoretical vs Experimental mass flow rate')
xlabel('P [$bar$]')
ylabel('G [$kg/s$]')
axis padded
figureEditor

u_theo = omega_theo*r_m;
V1_theo = u_theo*2;

cases = {'d32Pelton' 'd33Pelton'};
phi = atan(89/150);
% phi_deg = phi*180/pi;
% phi_theoretical = 22.62*pi/180;
A_feed = pi/4*(2.5*1e-3)^2;
figure
hold on
for i = 1:length(cases)
current_case = cases{i};

    Q = data.d32.Pelton(:,1); % [l/min]
    V1 = Q*1e-3/60/A_feed; % [m/s]
    
    omega = mean_strct.(current_case);
    u = omega*pi/30*mean_Diam/2;
    Eta_h = 2*(V1-u).*(1+cos(phi)).*u./(V1.^2);
    plot(Q,Eta_h,'-*')
end
Eta_h_theo = 2*(V1_theo-u_theo).*(1+cos(phi)).*u_theo./(V1_theo.^2);
% plot(Q,Eta_h_theo(1:length(Q)))
xlabel('Volumetric flow rate $Q$ [$l/min$]')
ylabel('Hydraulic Efficiency $\eta_h$')
title('Pelton Hydraulic Efficiency $\eta_h$')
legend('$\phi$ 32 mm Distributor','$\phi$ 33 mm Distributor')
figureEditor

cases = {'d32Single' 'd33Single'};
phi_theoretical = 60*pi/180;
figure
hold on
for i = 1:length(cases)
current_case = cases{i};

    Q = data.d32.Single(:,1); % [l/min]
    V1 = Q*1e-3/60/A_feed; % [m/s]
    
    omega = mean_strct.(current_case);
    u = omega*pi/30*mean_Diam/2;
    Eta_h = 2*(V1-u).*(1+cos(phi)).*u./(V1.^2);
    plot(Q,Eta_h,'-o')
end
xlabel('Volumetric flow rate $Q$ [$l/min$]')
ylabel('Hydraulic Efficiency $\eta_h$')
title('Single Pelton Hydraulic Efficiency $\eta_h$')
legend('$\phi$ 32 mm Distributor','$\phi$ 33 mm Distributor')
figureEditor

cases = 'd32Pelton';
mean_Diam = (30-3.6)*1e-3; % [m]
phi = atan(89/150);
phi_deg = phi*180/pi;




